//								EJEMPLO 23
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR1 en el modo contador ascendente de eventos externos
//
//Mediante el generador de onda cuadrada del laboratorio  se aplican pulsos por la 
//lnea RC0/T1CKI. La pantalla LCD visualizar, en decimal, el contenido del TMR1
//
//Si se selecciona una muy baja frecuencia en el generador (1H aprox.), se puede apreciar 
//claramente que los incrementos del contador se producen en los flancos ascendentes de la
//seal de onda cuadrada.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)
#include<lcd2.c>	//Incluye funciones para el LCD

int16	 temporal=0;

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	set_tris_c(0xff);	//Puerta C entrada
	set_timer1(0x00);	//Carga TMR1 con 0
	lcd_init();			//Inicia el LCD
	setup_timer_1(T1_EXTERNAL);	//TMR1 como contador externo de eventos

	while(1)
	{	
		lcd_enviar(LCD_COMANDO,LCD_HOME);	//Cursor Home
		temporal=get_timer1();	//Valor actual del TMR1
		printf(lcd_putc,"%05Lu",temporal);
	}
}	
